# 아이콘 생성 가이드

Chrome Extension에 필요한 아이콘들을 생성하는 방법입니다.

## 📋 필요한 아이콘

- `icon16.png` - 16x16px (확장 프로그램 페이지)
- `icon48.png` - 48x48px (확장 프로그램 관리)
- `icon128.png` - 128x128px (Chrome Web Store, 설치 시)

## 🎨 아이콘 생성 방법

### 방법 1: Figma/디자인 툴 사용

1. Figma, Adobe Illustrator 등에서 아이콘 디자인
2. 링크/체인 모양의 아이콘 추천 (🔗)
3. 각 사이즈로 PNG 내보내기

### 방법 2: 온라인 아이콘 생성기

무료 아이콘 생성 사이트:

- [Favicon.io](https://favicon.io/)
- [RealFaviconGenerator](https://realfavicongenerator.net/)
- [Canva](https://www.canva.com/)

### 방법 3: 이모지를 이미지로 변환

1. [Emoji to Image](https://emoji.gg/) 또는 유사 서비스 사용
2. 🔗 이모지 선택
3. PNG로 다운로드 후 각 사이즈로 리사이즈

### 방법 4: ImageMagick으로 생성 (추천)

```bash
# 텍스트 기반 심플한 아이콘 생성
convert -size 128x128 xc:#6366f1 \
  -gravity center \
  -pointsize 80 -fill white \
  -font "DejaVu-Sans-Bold" \
  -annotate +0+0 "🔗" \
  icon128.png

# 다른 사이즈 생성
convert icon128.png -resize 48x48 icon48.png
convert icon128.png -resize 16x16 icon16.png
```

### 방법 5: SVG에서 PNG로 변환

아래 SVG를 사용하여 PNG로 변환:

```svg
<svg width="128" height="128" xmlns="http://www.w3.org/2000/svg">
  <rect width="128" height="128" rx="24" fill="#6366f1"/>
  <path d="M45 60a18 18 0 0 0 27 15.6l11-11a18 18 0 0 0-25.5-25.5l-6.2 6.2M83 68a18 18 0 0 0-27-15.6l-11 11a18 18 0 0 0 25.5 25.5l6.2-6.2"
    stroke="white" stroke-width="8" stroke-linecap="round" fill="none"/>
</svg>
```

온라인 변환: [CloudConvert](https://cloudconvert.com/svg-to-png)

## 🎨 디자인 가이드라인

### 색상

- 메인 색상: #6366f1 (Indigo)
- 보조 색상: #8b5cf6 (Purple)
- 아이콘: White (#ffffff)

### 스타일

- 심플하고 명확한 디자인
- 링크/체인 모양 권장
- 모서리 라운드 적용 (16-24px)
- 충분한 여백 확보

### 최적화

- PNG-8 또는 PNG-24 포맷
- 투명 배경 사용 가능
- 파일 크기 최소화 (각 10KB 이하 권장)

## ⚡ 빠른 생성 (임시용)

개발/테스트용으로 빠르게 생성하려면:

```bash
# 단색 배경 아이콘 생성
convert -size 128x128 xc:#6366f1 -fill white \
  -gravity center -pointsize 64 \
  -draw "circle 64,64 64,32" icon128.png

convert icon128.png -resize 48x48 icon48.png
convert icon128.png -resize 16x16 icon16.png
```

## 📝 참고사항

- 모든 아이콘은 정사각형이어야 합니다
- 16x16은 작으므로 단순한 디자인 권장
- 128x128은 Chrome Web Store에 표시되므로 고품질로 제작
- 다크/라이트 모드 모두에서 잘 보이는 색상 선택

## 🔗 유용한 리소스

- [Google Material Icons](https://fonts.google.com/icons)
- [Heroicons](https://heroicons.com/)
- [Feather Icons](https://feathericons.com/)
- [Flaticon](https://www.flaticon.com/)
